# ChessNextMove Chrome Extension

Chess calculator extension that auto-detects chess boards on any website in real-time.

## Features

- **Universal Detection**: Automatically detects chess boards on any website
- **Real-time updates**: Watches for moves and updates the calculator instantly
- **Board orientation**: Auto-detects if you're playing white or black
- **Manual scan**: Screenshot scan button for fallback detection
- **PRO only**: Requires ChessNextMove PRO subscription

## Installation

### 1. Add Icons

Create PNG icons in the `icons/` folder:
- `icon16.png` (16x16)
- `icon32.png` (32x32)
- `icon48.png` (48x48)
- `icon128.png` (128x128)

### 2. Load Extension in Chrome

1. Open Chrome and go to `chrome://extensions/`
2. Enable "Developer mode" (toggle in top right)
3. Click "Load unpacked"
4. Select the `chessnextmove-extension` folder

## Usage

1. Click the extension icon to open the side panel
2. Log in with your ChessNextMove PRO account
3. Navigate to any page with a chess board
4. The calculator will auto-scan and show the best move!

## How It Works

### Programmatic Injection
The extension injects a universal content script only when you activate it. This means:
- No permissions needed for specific sites
- Works on ANY chess website
- Lighter and more efficient

### Board Detection
The content script detects chess boards by DOM structure:
- Web components (`wc-chess-board`, `chess-board`)
- Canvas-based boards (`cg-board`)
- Generic piece elements with position classes

### Communication Flow
1. User opens side panel
2. Content script injected into active tab
3. Script detects board position from DOM
4. Sends FEN to background script
5. Background forwards to side panel
6. Calculator loads position and shows analysis

## Files

```
chessnextmove-extension/
├── manifest.json          # Extension config
├── background.js          # Service worker + script injection
├── content-universal.js   # Universal board detector
├── sidepanel.html         # Side panel UI
├── sidepanel.css          # Side panel styles
├── sidepanel.js           # Side panel logic
├── icons/                 # Extension icons
│   ├── icon16.png
│   ├── icon32.png
│   ├── icon48.png
│   └── icon128.png
└── README.md              # This file
```

## Troubleshooting

### Extension not detecting board
- Make sure you're on a game page (not homepage)
- Try the "Scan" button for manual detection
- Check console for errors (right-click extension icon → Inspect)

### Calculator not loading
- Check if chessnextmove.ai is accessible
- Try logging out and back in
- Clear extension storage: chrome://extensions/ → Details → Clear storage

### Board orientation wrong
- The extension auto-detects orientation
- You can manually flip the board in the calculator

## Development

To modify the extension:
1. Make changes to the files
2. Go to `chrome://extensions/`
3. Click the refresh icon on the extension card
4. Test your changes

## Support

For issues or feature requests, contact support@chessnextmove.ai
